package gov.va.med.mhv.phr.decorator;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * This class is used to attempt to parse a string into a date by attempting multiple
 * patterns until one works.  Patterns are attempted in the order they are added
 * using the addFormat methods.  The format() methods will use the first DateFormat
 * that is added.   
 *  
 * @author jschmidt
 *
 */
public class MultiPatternDateFormat extends DateFormat {
	
	private static final long serialVersionUID = -6267563899433546339L;
	private static final Log LOG = LogFactory.getLog(MultiPatternDateFormat.class);

	private List<DateFormat> formats = new ArrayList<DateFormat>();
	
	public MultiPatternDateFormat(DateFormat df) {
		formats.add(df);
	}
	
	/**
	 * Adds a SimpleDateFormat with the given format string
	 * @param format
	 */
	public void addFormat(String format) {
		addFormat(new SimpleDateFormat(format));
	}
	
	public void addFormat(DateFormat df) {
		formats.add(df);
	}

	@Override
	public StringBuffer format(Date date, StringBuffer toAppendTo, 
			FieldPosition fieldPosition) {
		DateFormat df = formats.get(0);
		return df.format(date, toAppendTo, fieldPosition);
	}

	@Override
	public Date parse(String source, ParsePosition pos) {
		for(DateFormat df : formats) {
			Date result = df.parse(source, pos);
			if ( result != null ) {
				return result;
			}
		}
		return null;
	}

}
